/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.item;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import stormedpanda.simplyjetpacks.SimplyJetpacks;
import stormedpanda.simplyjetpacks.handlers.CommonJetpackHandler;
import stormedpanda.simplyjetpacks.item.JetpackArmorMaterial;
import stormedpanda.simplyjetpacks.item.JetpackItem;
import stormedpanda.simplyjetpacks.item.JetpackType;
import stormedpanda.simplyjetpacks.sound.SJSounds;
import stormedpanda.simplyjetpacks.util.JetpackUtil;
import stormedpanda.simplyjetpacks.util.KeyboardUtil;
import stormedpanda.simplyjetpacks.util.NBTUtil;
import stormedpanda.simplyjetpacks.util.SJTextUtil;

public class PotatoJetpackItem
extends JetpackItem {
    public PotatoJetpackItem() {
        super(JetpackType.POTATO, JetpackArmorMaterial.POTATO);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (CapabilityEnergy.ENERGY == null) {
            return;
        }
        tooltip.add(SJTextUtil.translate("tooltip", "jetpack_potato", new Object[0]));
        SJTextUtil.addBaseInfo(stack, tooltip);
        if (KeyboardUtil.isHoldingShift()) {
            tooltip.add(SJTextUtil.translate("tooltip", "jetpack_potato.warning", TextFormatting.RED, new Object[0]));
        } else {
            tooltip.add(SJTextUtil.getShiftText());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return null;
    }

    @Override
    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!player.func_175149_v() && stack == JetpackUtil.getFromBothSlots(player)) {
            this.flyUser(player, stack, this, true);
            if (this.getJetpackType().getChargerMode() && this.isChargerOn(stack)) {
                super.chargeInventory(player, stack);
            }
        }
    }

    @Override
    public void flyUser(PlayerEntity player, ItemStack stack, JetpackItem item, Boolean force) {
        if (super.isEngineOn(stack)) {
            if (this.isFired(stack)) {
                super.flyUser(player, stack, item, true);
                player.field_70759_as += 37.5f;
                if (item.getEnergy(stack) <= 0) {
                    Random random = new Random();
                    player.field_71071_by.func_184437_d(stack);
                    if (!player.field_70170_p.func_201670_d()) {
                        player.field_70170_p.func_217385_a((Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 4.0f, Explosion.Mode.NONE);
                    }
                    for (int i = 0; i <= random.nextInt(3) + 4; ++i) {
                        SimplyJetpacks.LOGGER.info("SJ2: CREATING FIREWORKS!");
                    }
                    player.func_71019_a(new ItemStack((IItemProvider)Items.field_151168_bH), false);
                    player.func_70097_a(new DamageSource("simplyjetpacks" + (random.nextBoolean() ? ".potato_jetpack" : ".jetpack_explode")), 100.0f);
                }
            } else if (force.booleanValue() || CommonJetpackHandler.isHoldingUp(player)) {
                if (this.isTimerSet(stack)) {
                    this.decrementTimer(stack, player);
                } else {
                    this.setTimer(stack, 50);
                }
            }
        }
    }

    public boolean isFired(ItemStack itemStack) {
        return NBTUtil.getBoolean(itemStack, "Fired");
    }

    private void setFired(ItemStack itemStack) {
        NBTUtil.setBoolean(itemStack, "Fired", true);
    }

    private boolean isTimerSet(ItemStack itemStack) {
        return NBTUtil.getBoolean(itemStack, "RocketTimerSet");
    }

    private void setTimer(ItemStack itemStack, int timer) {
        NBTUtil.setInt(itemStack, "RocketTimer", timer);
        NBTUtil.setBoolean(itemStack, "RocketTimerSet", true);
    }

    private void decrementTimer(ItemStack itemStack, PlayerEntity player) {
        int timer = NBTUtil.getInt(itemStack, "RocketTimer");
        timer = timer > 0 ? timer - 1 : 0;
        NBTUtil.setInt(itemStack, "RocketTimer", timer);
        if (timer == 0) {
            this.setFired(itemStack);
            player.field_70170_p.func_217384_a(player, (Entity)player, SJSounds.ROCKET, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }
}

